<?php

use Joomla\CMS\Cache\CacheController;
use Joomla\CMS\Cache\CacheControllerFactoryInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Language\Language;
use Joomla\CMS\User\User;
use Joomla\Component\Joomlaupdate\Administrator\Model\UpdateModel;
use Joomla\Database\DatabaseInterface;
use Joomla\Registry\Registry;

class WatchfulliFactory
{

    /**
     * @return Joomla\CMS\Application\CMSWebApplicationInterface|Joomla\CMS\Application\CMSApplication
     */
    public static function getApplication()
    {
        return Factory::getApplication();
    }

    /**
     * @return Joomla\Registry\Registry
     */
    public static function getConfig(): Registry
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return Factory::getConfig();
            default:
                return self::getApplication()->getConfig();
        }
    }

    /**
     * @return CacheController
     */
    public static function getCacheController(): CacheController
    {
        $group = 'com_watchfulli';
        $handler = 'callback';
        $storage = null;

        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return Factory::getCache($group, $handler, $storage);
            default:
                $options = ['defaultgroup' => $group];

                if (isset($storage)) {
                    $options['storage'] = $storage;
                }
                return Factory::getContainer()->get(CacheControllerFactoryInterface::class)->createCacheController($handler, $options);
        }
    }

    /**
     * @return JInput|\Joomla\Input\Input
     */
    public static function getInput()
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return self::getApplication()->input;
            default:
                return self::getApplication()->getInput();
        }
    }

    /**
     * @return JDatabaseDriver|\Joomla\Database\DatabaseDriver
     */
    public static function getDbo()
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return Factory::getDbo();
            default:
                return Factory::getContainer()->get(DatabaseInterface::class);
        }
    }

    /**
     * @return User|null
     */
    public static function getUser()
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return Factory::getUser();
            default:
                return self::getApplication()->getIdentity();
        }
    }

    /**
     * @return JoomlaupdateModelDefault|UpdateModel
     */
    public static function getUpdateModel()
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                require_once JPATH_ADMINISTRATOR . '/components/com_joomlaupdate/models/default.php';
                return new JoomlaupdateModelDefault();
            default:
                return new UpdateModel();
        }
    }

    /**
     * @return \Joomla\Http\Http|\Joomla\CMS\Http\Http
     */
    public static function getHttp()
    {
        $joomlaVersion = WatchfulliJoomlaVersion::getVersion();

        if (version_compare($joomlaVersion, '4.0.0', '<')) {
            return HttpFactory::getHttp(null, ['curl', 'stream']);
        }

        if (version_compare($joomlaVersion, '6.0', '<')) {
            return HttpFactory::getHttp([], ['curl', 'stream']);
        }

        return (new \Joomla\Http\HttpFactory())->getHttp([], ['curl', 'stream']);
    }

    public static function getLanguage(): Language
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return Factory::getLanguage();
            default:
                return self::getApplication()->getLanguage();
        }
    }

    public static function useStyle(string $path)
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion()) {
            case 3:
                return HTMLHelper::stylesheet($path);
            default:
                return self::getApplication()->getDocument()->getWebAssetManager()->registerAndUseStyle('com_watchfulli', $path);
        }
    }

    public static function dispatch(string $eventName, array $args): array
    {
        switch (WatchfulliJoomlaVersion::getMajorVersion())  {
            case 3:
                return self::getApplication()->triggerEvent($eventName, $args);
            default:
                $dispatcher = self::getApplication()->getDispatcher();
                $result = $dispatcher->dispatch($eventName, new Joomla\Event\Event($eventName, $args));
                return $result['result'] ?? [];
        }
    }
}