<?php

use Joomla\CMS\Version;

class WatchfulliJoomlaVersion
{
    public static function getMajorVersion(): int
    {
        return Version::MAJOR_VERSION;
    }

    public static function getVersion(): string
    {
        return implode(
            ".",
            [
                Version::MAJOR_VERSION,
                Version::MINOR_VERSION,
                Version::PATCH_VERSION,
            ]
        );
    }

    public static function getExtraVersion(): string
    {
        $version = Version::MAJOR_VERSION . '.' . Version::MINOR_VERSION . '.' . Version::PATCH_VERSION;

        if (!empty(Version::EXTRA_VERSION)) {
            $version .= '-' . Version::EXTRA_VERSION;
        }

        return $version;
    }
}