<?php
/**
 * @version     site/controller.php 2020-05-28 zanardigit
 * @package     Watchful Client
 * @author      Watchful
 * @authorUrl   @ant_authorUrl@
 * @copyright   @ant_copyright@
 * @license     @ant_license@
 */

use Joomla\CMS\MVC\Controller\BaseController;

defined('_JEXEC') or die;
defined('WATCHFULLI_PATH') or die;

class WatchfulliController extends BaseController
{
	/** @var WatchfulliActions */
	protected $action;

	/** @var WatchfulliScanner */
	protected $scanner;

	/**
	 * @param   array  $config
	 */
	public function __construct(array $config = [])
	{
		parent::__construct($config);
		$this->action  = new WatchfulliActions();
		$this->scanner = new WatchfulliScanner();
	}

	public function display($cachable = false, $urlparams = [])
	{
		$this->input->set('view', 'default');

		return parent::display($cachable, $urlparams); // TODO: Change the autogenerated stub
	}

	public function doUpdate()
	{
		$this->action->doUpdate();
	}

    public function changeExtensionStatus()
    {
        $this->action->changeExtensionStatus();
    }

	public function cleanJoomlaCache()
	{
		$app = WatchfulliFactory::getApplication();
		if ($this->action->cleanJoomlaCache())
		{
			$app->close("ok");
		}
		$app->close("ko");
	}

	public function getLog()
	{
		$this->action->getLog();
	}

	public function test()
	{
		$this->action->test();
	}

	public function auditJoomlaConfiguration()
	{
		$this->scanner->auditJoomlaConfiguration();
	}

	public function auditFilesPermissions()
	{
		$this->scanner->auditFilesPermissions();
	}

	public function auditFoldersPermissions()
	{
		$this->scanner->auditFolderPermissions();
	}

	public function auditCoreIntegrity()
	{
		$this->scanner->auditJoomlaCoreIntegrity();
	}

	public function auditMalwareScanner()
	{
		$this->scanner->auditMalwareScanner();
	}

	public function checkExtensionsUpdates()
	{
		$this->action->checkExtensionsUpdates();
	}

	public function whiteListIp()
	{
		new WatchfulliWhitelistIp();
	}

}
