<?php
/**
 * @version     admin/classes/recursiveListing.php 2020-05-27
 * @package     Watchful Client
 * @author      Watchful
 * @authorUrl   @ant_authorUrl@
 * @copyright   @ant_copyright@
 * @license     @ant_license@
 */
defined('_JEXEC') or die('Restricted access');

class WatchfulliRecursiveListing
{
	public static function getStructure(string $path, int $time_limit = 30): stdClass
    {
		$structure        = new stdClass();
		$structure->dirs  = [];
		$structure->files = [];

		// give the script extra seconds to run, in case of lots of files
		@set_time_limit($time_limit);

		$iterator = new RecursiveIteratorIterator(
			new RecursiveDirectoryIterator($path), RecursiveIteratorIterator::SELF_FIRST, RecursiveIteratorIterator::CATCH_GET_CHILD
		);

		foreach ($iterator as $file)
		{
			// add more time for this script to process
			@set_time_limit($time_limit);

			if ($file->getFilename() == '..')
			{
				continue;
			}

			// ignore unreadable
			if (!self::isReadable($file))
			{
				continue;
			}

			if ($file->isDir())
			{
				$structure->dirs[] = $file->getRealpath();
			}
			else
			{
				$structure->files[] = $file->getRealpath();
			}
		}

		$structure->files = array_unique($structure->files);
		$structure->files = array_values($structure->files);

		$structure->dirs = array_unique($structure->dirs);
		$structure->dirs = array_values($structure->dirs);

		return $structure;
	}

	/**
	 * @param   object  $structure
	 *
	 */
	public static function getNonCoreFiles($structure, array $hashes, int $time_limit = 30): array
    {
		$hashPaths    = [];
		$nonCoreFiles = [];

		foreach ($hashes as $hash)
		{
			$hashPaths[] = $hash[0];
		}

		foreach ($structure->files as $file)
		{
			// add more time to process this file
			@set_time_limit($time_limit);

			//Remove path base
			$hashBasePath = str_replace(JPATH_BASE . '/', '', $file);
			if (!in_array($hashBasePath, $hashPaths))
			{
				$nonCoreFiles[] = $file;
			}
		}

		return $nonCoreFiles;
	}

	/**
	 * Check if file is readable
	 *
	 * @param   SplFileInfo  $file
	 */
	public static function isReadable($file): bool
    {
		try
		{
			return ($file->isReadable());
		}
		catch (Exception $ex)
		{
			return false;
		}
	}

}
