<?php
/**
 * @version     site/controller.php 2020-05-28 zanardigit
 * @package     Watchful Client
 * @author      Watchful
 * @authorUrl   https://watchful.net
 * @copyright   Copyright (c) 2012-2023 Watchful
 * @license     GNU/GPL v3 or later
 */

use Joomla\CMS\Application\SiteApplication;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;

defined('_JEXEC') or die;
defined('WATCHFULLI_PATH') or die;

class WatchfulliController extends BaseController
{
	/** @var WatchfulliActions */
	protected $action;

	/** @var WatchfulliScanner */
	protected $scanner;

	/**
	 * @param   array  $config
	 */
	public function __construct($config = [])
	{
		parent::__construct($config);
		$this->action  = new WatchfulliActions();
		$this->scanner = new WatchfulliScanner();
	}

	public function display($cachable = false, $urlparams = [])
	{
		$this->input->set('view', 'default');

		return parent::display($cachable, $urlparams); // TODO: Change the autogenerated stub
	}

	public function doUpdate()
	{
		$this->action->doUpdate();
	}

    public function changeExtensionStatus()
    {
        $this->action->changeExtensionStatus();
    }

	public function cleanJoomlaCache()
	{
		/** @var SiteApplication $app */
		$app = Factory::getApplication();
		if ($this->action->cleanJoomlaCache())
		{
			$app->close("ok");
		}
		$app->close("ko");
	}

	public function getLog()
	{
		$this->action->getLog();
	}

	public function test()
	{
		$this->action->test();
	}

	public function auditJoomlaConfiguration()
	{
		$this->scanner->auditJoomlaConfiguration();
	}

	public function auditFilesPermissions()
	{
		$this->scanner->auditFilesPermissions();
	}

	public function auditFoldersPermissions()
	{
		$this->scanner->auditFolderPermissions();
	}

	public function auditCoreIntegrity()
	{
		$this->scanner->auditJoomlaCoreIntegrity();
	}

	public function auditMalwareScanner()
	{
		$this->scanner->auditMalwareScanner();
	}

	public function fileManager()
	{
		$this->action->fileManager();
	}

	public function checkExtensionsUpdates()
	{
		$this->action->checkExtensionsUpdates();
	}

	public function whiteListIp()
	{
		new WatchfulliWhitelistIp();
	}

}
